/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class FluidCuboid {
    protected static final Map<Direction, FluidFace> DEFAULT_FACES = new EnumMap<Direction, FluidFace>(Direction.class);
    private final Vector3f from;
    private final Vector3f to;
    private final Map<Direction, FluidFace> faces;
    @Nullable
    private Vector3f fromScaled;
    @Nullable
    private Vector3f toScaled;

    public FluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidFace> faces) {
        this.from = from;
        this.to = to;
        this.faces = faces;
    }

    @Nullable
    public FluidFace getFace(Direction face) {
        return this.faces.get(face);
    }

    public Vector3f getFromScaled() {
        if (this.fromScaled == null) {
            this.fromScaled = this.from.m_122281_();
            this.fromScaled.m_122261_(0.0625f);
        }
        return this.fromScaled;
    }

    public Vector3f getToScaled() {
        if (this.toScaled == null) {
            this.toScaled = this.to.m_122281_();
            this.toScaled.m_122261_(0.0625f);
        }
        return this.toScaled;
    }

    public static FluidCuboid fromJson(JsonObject json) {
        Vector3f from = ModelHelper.arrayToVector(json, "from");
        Vector3f to = ModelHelper.arrayToVector(json, "to");
        Map<Direction, FluidFace> faces = FluidCuboid.getFaces(json);
        return new FluidCuboid(from, to, faces);
    }

    public static List<FluidCuboid> listFromJson(JsonObject parent, String key) {
        JsonElement json = parent.get(key);
        if (json.isJsonObject()) {
            return Collections.singletonList(FluidCuboid.fromJson(json.getAsJsonObject()));
        }
        if (json.isJsonArray()) {
            return JsonHelper.parseList(json.getAsJsonArray(), key, FluidCuboid::fromJson);
        }
        throw new JsonSyntaxException("Invalid fluid '" + key + "', must be an array or an object");
    }

    protected static Map<Direction, FluidFace> getFaces(JsonObject json) {
        if (!json.has("faces")) {
            return DEFAULT_FACES;
        }
        EnumMap<Direction, FluidFace> faces = new EnumMap<Direction, FluidFace>(Direction.class);
        JsonObject object = GsonHelper.m_13930_((JsonObject)json, (String)"faces");
        for (Map.Entry entry : object.entrySet()) {
            String name = (String)entry.getKey();
            Direction dir = Direction.m_122402_((String)name);
            if (dir != null) {
                JsonObject face = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)name);
                boolean flowing = GsonHelper.m_13855_((JsonObject)face, (String)"flowing", (boolean)false);
                int rotation = ModelHelper.getRotation(face, "rotation");
                faces.put(dir, new FluidFace(flowing, rotation));
                continue;
            }
            throw new JsonSyntaxException("Unknown face '" + name + "'");
        }
        return faces;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Map<Direction, FluidFace> getFaces() {
        return this.faces;
    }

    static {
        for (Direction direction : Direction.values()) {
            DEFAULT_FACES.put(direction, FluidFace.NORMAL);
        }
    }

    public record FluidFace(boolean isFlowing, int rotation) {
        public static final FluidFace NORMAL = new FluidFace(false, 0);
    }
}

